<?php

use yii\helpers\Html;
use kartik\widgets\ActiveForm;
use kartik\builder\Form;
use kartik\datecontrol\DateControl;
use kartik\builder\TabularForm;
use Yii\helpers\Url;
use yii\bootstrap\Modal;
use yii\widgets\Pjax;


/**
 * @var yii\web\View $this
 * @var app\models\Clientes $model
 * @var yii\widgets\ActiveForm $form
 */

?>

<div class="clientes-form">

    <?php     $form = ActiveForm::begin(['type'=>ActiveForm::TYPE_HORIZONTAL]);

    echo Form::widget([
	    'model' => $model,
	    'form' => $form,
	    'columns' => 2,
	    'attributes' => [
    
				
				'razon_social'=>['type'=> Form::INPUT_TEXT, 'options'=>['placeholder'=>'Ingrese Razon Social...', 'maxlength'=>50]], 


			    
				
				'persona'=>['type'=> Form::INPUT_TEXT, 'options'=>['placeholder'=>'Ingrese Persona...', 'maxlength'=>1]], 


			    
				
				'rfc'=>['type'=> Form::INPUT_TEXT, 'options'=>['placeholder'=>'Ingrese Rfc...', 'maxlength'=>20]], 


			    
				
				'contacto'=>['type'=> Form::INPUT_TEXT, 'options'=>['placeholder'=>'Ingrese Contacto...', 'maxlength'=>100]], 


			    
				
				'calle'=>['type'=> Form::INPUT_TEXT, 'options'=>['placeholder'=>'Ingrese Calle...', 'maxlength'=>100]], 


			    
				
				'numero'=>['type'=> Form::INPUT_TEXT, 'options'=>['placeholder'=>'Ingrese Numero...', 'maxlength'=>10]], 


			    
				
				'interior'=>['type'=> Form::INPUT_TEXT, 'options'=>['placeholder'=>'Ingrese Interior...', 'maxlength'=>10]], 


			    
				
				'colonia'=>['type'=> Form::INPUT_TEXT, 'options'=>['placeholder'=>'Ingrese Colonia...', 'maxlength'=>50]], 


			    
				
				'ciudad'=>['type'=> Form::INPUT_TEXT, 'options'=>['placeholder'=>'Ingrese Ciudad...', 'maxlength'=>50]], 


			]]);
 ?> 
<p><?= Html::button('Selecciona Estados', [
			        	'value' => Url::to(['estados/picker-ajax','parent_model' => 'Clientes', 'relation' => 'Estados']),
			        	'class'=> 'btn btn-success',
			        	'id'=> 'modalEstadosPickerButton',
			            'onclick' => "
			            		$('#modalEstadosPicker').modal('show')
			            			.find('#modalEstadosPickerContent')
			            			.load($(this).attr('value'));
			            			
			            		",	
						]);
 ?>
</p>				
					    
 <?php 					    
						echo Form::widget([
						    'model' => $model,
						    'form' => $form,
						    'columns' => 2,
						    'attributes' => [				
				
				    
				
				'estados_estado'=>['type'=> TabularForm::INPUT_TEXT, 'options'=>['placeholder'=>'Selecciona Estados', 'readonly' => true]], 


			    
				
				'codigo_postal'=>['type'=> Form::INPUT_TEXT, 'options'=>['placeholder'=>'Ingrese Codigo Postal...', 'maxlength'=>5]], 


			]]);
 ?> 
<p><?= Html::button('Selecciona Paises', [
			        	'value' => Url::to(['paises/picker-ajax','parent_model' => 'Clientes', 'relation' => 'Paises']),
			        	'class'=> 'btn btn-success',
			        	'id'=> 'modalPaisesPickerButton',
			            'onclick' => "
			            		$('#modalPaisesPicker').modal('show')
			            			.find('#modalPaisesPickerContent')
			            			.load($(this).attr('value'));
			            			
			            		",	
						]);
 ?>
</p>				
					    
 <?php 					    
						echo Form::widget([
						    'model' => $model,
						    'form' => $form,
						    'columns' => 2,
						    'attributes' => [				
				
				    
				
				'paises_pais'=>['type'=> TabularForm::INPUT_TEXT, 'options'=>['placeholder'=>'Selecciona Paises', 'readonly' => true]], 


			    
				
				'oficina_alta'=>['type'=> Form::INPUT_TEXT, 'options'=>['placeholder'=>'Ingrese Oficina Alta...', 'maxlength'=>10]], 


			    
				
				'estatus'=>['type'=> Form::INPUT_TEXT, 'options'=>['placeholder'=>'Ingrese Estatus...', 'maxlength'=>5]], 


			    
				
				'cuenta_contable'=>['type'=> Form::INPUT_TEXT, 'options'=>['placeholder'=>'Ingrese Cuenta Contable...', 'maxlength'=>50]], 


			    
				
				'dias_credito'=>['type'=> Form::INPUT_TEXT, 'options'=>['placeholder'=>'Ingrese Dias Credito...']], 


			    
				
				'dias_pago'=>['type'=> Form::INPUT_TEXT, 'options'=>['placeholder'=>'Ingrese Dias Pago...']], 


			    
				
				'poliza_seguro'=>['type'=> Form::INPUT_TEXT, 'options'=>['placeholder'=>'Ingrese Poliza Seguro...', 'maxlength'=>50]], 


			    
				
				'factor_seguro'=>['type'=> Form::INPUT_TEXT, 'options'=>['placeholder'=>'Ingrese Factor Seguro...', 'maxlength'=>20]], 


			    
				
				'telefono'=>['type'=> Form::INPUT_TEXT, 'options'=>['placeholder'=>'Ingrese Telefono...', 'maxlength'=>20]], 


			    
				
				'radio'=>['type'=> Form::INPUT_TEXT, 'options'=>['placeholder'=>'Ingrese Radio...', 'maxlength'=>20]], 


			    
				
				'cuenta_pago'=>['type'=> Form::INPUT_TEXT, 'options'=>['placeholder'=>'Ingrese Cuenta Pago...', 'maxlength'=>50]], 


			    
				
				'metodo_pago'=>['type'=> Form::INPUT_TEXT, 'options'=>['placeholder'=>'Ingrese Metodo Pago...', 'maxlength'=>20]], 


			    
				
				'forma_pago'=>['type'=> Form::INPUT_TEXT, 'options'=>['placeholder'=>'Ingrese Forma Pago...', 'maxlength'=>20]], 


			    
				
				'cuenta_extranjera'=>['type'=> Form::INPUT_TEXT, 'options'=>['placeholder'=>'Ingrese Cuenta Extranjera...', 'maxlength'=>20]], 


			    
				
				'usuario'=>['type'=> Form::INPUT_TEXT, 'options'=>['placeholder'=>'Ingrese Usuario...', 'maxlength'=>20]], 


			    
				
				'contrasena'=>['type'=> Form::INPUT_TEXT, 'options'=>['placeholder'=>'Ingrese Contrasena...', 'maxlength'=>20]], 


			    
				
				'correo_principal'=>['type'=> Form::INPUT_TEXT, 'options'=>['placeholder'=>'Ingrese Correo Principal...', 'maxlength'=>50]], 


			    
				
				'correo_facturas'=>['type'=> Form::INPUT_TEXT, 'options'=>['placeholder'=>'Ingrese Correo Facturas...', 'maxlength'=>50]], 


			    
				
				'correo_cobranza'=>['type'=> Form::INPUT_TEXT, 'options'=>['placeholder'=>'Ingrese Correo Cobranza...', 'maxlength'=>50]], 


			    
				
				'correo_trafico'=>['type'=> Form::INPUT_TEXT, 'options'=>['placeholder'=>'Ingrese Correo Trafico...', 'maxlength'=>50]], 


			    
				
				'correo_almacen'=>['type'=> Form::INPUT_TEXT, 'options'=>['placeholder'=>'Ingrese Correo Almacen...', 'maxlength'=>50]], 


			    
				
				'correo_evidencias'=>['type'=> Form::INPUT_TEXT, 'options'=>['placeholder'=>'Ingrese Correo Evidencias...', 'maxlength'=>50]], 


			    
				
				'destinos'=>['type'=> Form::INPUT_TEXT, 'options'=>['placeholder'=>'Ingrese Destinos...', 'maxlength'=>100]], 


			    
				
				'tarifas'=>['type'=> Form::INPUT_TEXT, 'options'=>['placeholder'=>'Ingrese Tarifas...', 'maxlength'=>100]], 


			    
				
				'ubicacion'=>['type'=> Form::INPUT_TEXT, 'options'=>['placeholder'=>'Ingrese Ubicacion...', 'maxlength'=>100]], 


			
    ]
    ]);

	
    	    ?>  

<?php 		    echo Form::widget([
		    'model' => $model,
		    'form' => $form,
		    'columns' => 2,
		    'attributes' => [    	
			
									'id'=>['type'=> TabularForm::INPUT_HIDDEN, 'label'=> false],

	
		    						'estados_id'=>['type'=> TabularForm::INPUT_HIDDEN, 'label'=> false],

	
		    						'paises_id'=>['type'=> TabularForm::INPUT_HIDDEN, 'label'=> false],

	
		    		    	]
    		]);
   		?>    
    

<?php    echo Html::submitButton($model->isNewRecord ? Yii::t('app', 'Create') : Yii::t('app', 'Update'), ['class' => $model->isNewRecord ? 'btn btn-success' : 'btn btn-primary']);
    ActiveForm::end(); ?>

</div>


<?php
	Modal::begin([
		'header' => '<h4>Selecciona Estados</h4>',
		'id' => 'modalEstadosPicker',
		'size'=> 'modal-lg',
		]);

	echo "<div id='modalEstadosPickerContent'></div>" ;	
	Modal::end();
	

	Modal::begin([
		'header' => '<h4>Selecciona Paises</h4>',
		'id' => 'modalPaisesPicker',
		'size'=> 'modal-lg',
		]);

	echo "<div id='modalPaisesPickerContent'></div>" ;	
	Modal::end();
	

?>